////////////////////////////////////////////////////////////////////////////////
//
// © 1999 – 2019 OneSpan North America Inc. All rights reserved.
// All rights reserved. https://www.onespan.com/
//
////////////////////////////////////////////////////////////////////////////////

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN

/**
 * The {@link OrchestrationWarning} class is the base class used for asynchronous warning management in
 * the Orchestration SDK.
 */

NS_REFINED_FOR_SWIFT
@interface OrchestrationWarning : NSObject

- (instancetype)init NS_UNAVAILABLE;
+ (instancetype)new NS_UNAVAILABLE;

/** warning code attached to the warning (see OrchestrationWarningCodes.h)*/
@property (nonatomic, readonly) NSInteger warningCode;

/** error coming from another SDK */
@property (nonatomic, readonly, nullable) NSError *error;

/**
 * Give the intial Error Code coming from one of our SDK
 * 0 otherwise.
 */
@property (nonatomic, readonly) NSInteger internalErrorCode;

@end

NS_ASSUME_NONNULL_END
